<?php
session_start();
require 'db.php';

/*
if(!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit;
}
*/

if(isset($_POST['upload'])){

    $exam_id       = $_POST['exam_id'];
    $subject_id    = $_POST['subject_id'];
    $year          = $_POST['year'];
    $question_no   = $_POST['question_no']; // NEW FIELD
    $question      = $_POST['question'];
    $option_a      = $_POST['option_a'];
    $option_b      = $_POST['option_b'];
    $option_c      = $_POST['option_c'];
    $option_d      = $_POST['option_d'];
    $correct_option = $_POST['correct_option'];

    // CHECK IF THIS QUESTION NUMBER ALREADY EXISTS
    $check = $conn->prepare("SELECT id FROM questions WHERE subject = ? AND year = ? AND question_no = ?");
    $check->bind_param("iii", $subject_id, $year, $question_no);
    $check->execute();
    $result = $check->get_result();

    if($result->num_rows > 0){
        $error = "ERROR: Question No. $question_no for this subject & year already exists! You can only EDIT it.";
    } else {
        // Insert new question
        $stmt = $conn->prepare("
            INSERT INTO questions 
            (exam_type, subject, year, question_no, question_text, option_a, option_b, option_c, option_d, correct_option) 
            VALUES (?,?,?,?,?,?,?,?,?,?)
        ");

        $stmt->bind_param(
            "iiisssssss",
            $exam_id, 
            $subject_id, 
            $year, 
            $question_no,
            $question, 
            $option_a, 
            $option_b, 
            $option_c, 
            $option_d, 
            $correct_option
        );

        if($stmt->execute()){
            $success = "Question No. $question_no uploaded successfully!";
        } else {
            $error = "Failed to upload question!";
        }
    }
}

// Fetch exams & subjects
$exams = $conn->query("SELECT * FROM exams");
$subjects = $conn->query("SELECT * FROM subjects");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Upload Questions - Admin</title>
<link rel="stylesheet" href="../dist/css/style.css">
</head>
<body>
<div class="container mt-5">
    <h2>Upload Questions</h2>

    <?php if(isset($success)) echo "<p style='color:green;'>$success</p>"; ?>
    <?php if(isset($error)) echo "<p style='color:red;'>$error</p>"; ?>

    <form method="POST">

        <label>Exam:</label>
        <select name="exam_id" class="form-control mb-2" required>
            <option value="">Select Exam</option>
            <?php while($exam = $exams->fetch_assoc()): ?>
                <option value="<?php echo $exam['id']; ?>">
                    <?php echo strtoupper($exam['exam_name']); ?>
                </option>
            <?php endwhile; ?>
        </select>

        <label>Subject:</label>
        <select name="subject_id" class="form-control mb-2" required>
            <option value="">Select Subject</option>
            <?php while($subject = $subjects->fetch_assoc()): ?>
                <option value="<?php echo $subject['id']; ?>">
                    <?php echo $subject['name']; ?>
                </option>
            <?php endwhile; ?>
        </select>

        <label>Year:</label>
        <input type="number" name="year" class="form-control mb-2" placeholder="e.g 2023" required>

        <label>Question No:</label>
        <input type="number" name="question_no" class="form-control mb-2" placeholder="e.g 3" required>

        <label>Question:</label>
        <textarea name="question" class="form-control mb-2" required></textarea>

        <label>Option A:</label>
        <input type="text" name="option_a" class="form-control mb-2" required>

        <label>Option B:</label>
        <input type="text" name="option_b" class="form-control mb-2" required>

        <label>Option C:</label>
        <input type="text" name="option_c" class="form-control mb-2" required>

        <label>Option D:</label>
        <input type="text" name="option_d" class="form-control mb-2" required>

        <label>Correct Option:</label>
        <select name="correct_option" class="form-control mb-2" required>
            <option value="">Select Correct Option</option>
            <option value="a">A</option>
            <option value="b">B</option>
            <option value="c">C</option>
            <option value="d">D</option>
        </select>

        <button type="submit" name="upload" class="btn btn-warning">Upload Question</button>

    </form>
</div>
</body>
</html>
